namespace Microsoft.Samples.PlanMyNight.Web.Helpers.Tests
{
    using System;
    using System.Web;
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;

    [TestClass]
    public class SessionItineraryContainerFixture
    {
        [TestMethod]
        public void GetCurrentEmptySessionReturnsNull()
        {
            var session = new Mock<HttpSessionStateBase>();
            session.SetupGet(o => o["CurrentItinerary"]).Returns(default(Itinerary));
            var context = new Mock<HttpContextBase>();
            context.Setup(o => o.Session).Returns(session.Object);
            var container = new SessionItineraryContainer(context.Object);

            var result = container.GetCurrent();

            Assert.IsNull(result);
            session.VerifyAll();
        }

        [TestMethod]
        public void GetCurrentReturnsObject()
        {
            var session = new Mock<HttpSessionStateBase>();
            session.SetupGet(o => o["CurrentItinerary"]).Returns(new Itinerary());
            var context = new Mock<HttpContextBase>();
            context.Setup(o => o.Session).Returns(session.Object);
            var container = new SessionItineraryContainer(context.Object);

            var result = container.GetCurrent();

            Assert.IsNotNull(result);
            session.VerifyAll();
        }

        [TestMethod]
        public void SetCurrentSavesInSession()
        {
            Itinerary savedItinerary = null;
            var session = new Mock<HttpSessionStateBase>();
            session.SetupSet(o => o["CurrentItinerary"] = It.IsAny<object>()).Callback((string name, object m) => savedItinerary = (Itinerary)m);
            var context = new Mock<HttpContextBase>();
            context.Setup(o => o.Session).Returns(session.Object);
            var container = new SessionItineraryContainer(context.Object);

            container.SetCurrent(new Itinerary());

            Assert.IsNotNull(savedItinerary);
            context.VerifyAll();
        }
    }
}
